/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import net.skinsrestorer.shadow.ijannotations.Language;
import net.skinsrestorer.shadow.mariadb.MariaDbPoolDataSource;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class MySQL {
    private final SRLogger logger;
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final int maxPoolSize;
    private final String options;
    private MariaDbPoolDataSource poolDataSource;

    public void createTable() {
        this.execute("CREATE TABLE IF NOT EXISTS `" + Config.MYSQL_PLAYER_TABLE + "` (`Nick` varchar(17) COLLATE utf8_unicode_ci NOT NULL,`Skin` varchar(19) COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (`Nick`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci", new Object[0]);
        this.execute("CREATE TABLE IF NOT EXISTS `" + Config.MYSQL_SKIN_TABLE + "` (`Nick` varchar(19) COLLATE utf8_unicode_ci NOT NULL,`Value` text COLLATE utf8_unicode_ci,`Signature` text COLLATE utf8_unicode_ci,`timestamp` text COLLATE utf8_unicode_ci,PRIMARY KEY (`Nick`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci", new Object[0]);
        if (!this.columnExists(Config.MYSQL_SKIN_TABLE, "timestamp")) {
            this.execute("ALTER TABLE `" + Config.MYSQL_SKIN_TABLE + "` ADD `timestamp` text COLLATE utf8_unicode_ci;", new Object[0]);
        }
        if (this.columnVarCharLength(Config.MYSQL_PLAYER_TABLE, "Nick") < 17) {
            this.execute("ALTER TABLE `" + Config.MYSQL_PLAYER_TABLE + "` MODIFY `Nick` varchar(17) COLLATE utf8_unicode_ci NOT NULL;", new Object[0]);
        }
        if (this.columnVarCharLength(Config.MYSQL_PLAYER_TABLE, "Skin") < 19) {
            this.execute("ALTER TABLE `" + Config.MYSQL_PLAYER_TABLE + "` MODIFY `Skin` varchar(19) COLLATE utf8_unicode_ci NOT NULL;", new Object[0]);
        }
        if (this.columnVarCharLength(Config.MYSQL_SKIN_TABLE, "Nick") < 19) {
            this.execute("ALTER TABLE `" + Config.MYSQL_SKIN_TABLE + "` MODIFY `Nick` varchar(19) COLLATE utf8_unicode_ci NOT NULL;", new Object[0]);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean columnExists(String tableName, String columnName) {
        try (Connection connection = this.poolDataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?");
                try {
                    statement.setString(1, tableName);
                    statement.setString(2, columnName);
                    ResultSet resultSet = statement.executeQuery();
                    resultSet.next();
                    boolean bl2 = bl = resultSet.getInt(1) > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.severe("Error checking if column exists", e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int columnVarCharLength(String tableName, String columnName) {
        try (Connection connection = this.poolDataSource.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement("SELECT CHARACTER_MAXIMUM_LENGTH FROM information_schema.COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?");
                try {
                    statement.setString(1, tableName);
                    statement.setString(2, columnName);
                    ResultSet resultSet = statement.executeQuery();
                    resultSet.next();
                    n = resultSet.getInt(1);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.logger.severe("Error checking if column exists", e);
            return -1;
        }
    }

    public void connectPool() throws SQLException {
        this.poolDataSource = new MariaDbPoolDataSource("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?user=" + this.username + "&password=" + this.password + "&permitMysqlScheme&maxPoolSize=" + this.maxPoolSize + "&" + this.options);
        this.logger.info("Connected to MySQL!");
    }

    public void execute(@Language(value="sql") String query, Object ... vars) {
        try (Connection connection = this.poolDataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            this.fillPreparedStatement(ps, vars);
            ps.execute();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1060) {
                return;
            }
            e.printStackTrace();
            this.logger.warning("MySQL error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CachedRowSet query(@Language(value="sql") String query, Object ... vars) {
        try (Connection connection = this.poolDataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            this.fillPreparedStatement(ps, vars);
            try (ResultSet rs = ps.executeQuery();){
                CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();
                crs.populate(rs);
                if (!crs.next()) return null;
                CachedRowSet cachedRowSet = crs;
                return cachedRowSet;
            }
        }
        catch (SQLException e) {
            this.logger.warning("MySQL error: " + e.getMessage());
        }
        return null;
    }

    private void fillPreparedStatement(PreparedStatement ps, Object ... vars) throws SQLException {
        int i = 0;
        for (Object obj : vars) {
            ++i;
            try {
                ps.setObject(i, obj);
            }
            catch (SQLException e) {
                throw new SQLException("Error while setting prepared statement variable #" + i + " (" + obj + "): " + e.getMessage());
            }
        }
    }

    public MySQL(SRLogger logger, String host, int port, String database, String username, String password, int maxPoolSize, String options) {
        this.logger = logger;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.maxPoolSize = maxPoolSize;
        this.options = options;
    }
}

